clc
close all
clear all

%% efficiency average - 5.2 l/min
sim_eff = xlsread('2014120401.xlsx','average efficiency','D3:D9');
com_eff = xlsread('2014120401.xlsx','average efficiency','I3:I9');

%efficiency differences
dif1 = (com_eff-sim_eff)./com_eff;
diff1 = mean(dif1)*100;
fprintf('\nThe difference between simple and complex efficiency is %3.2f percent (5.2l/min)\n',diff1);

%% efficiency average - 6.8 l/min
simeff = xlsread('2014120401.xlsx','average efficiency','D14:D20');
comeff = xlsread('2014120401.xlsx','average efficiency','I14:I20');

%efficiency differences
dif2 = (comeff-simeff)./comeff;
diff2 = mean(dif2)*100;
fprintf('\nThe difference between simple and complex efficiency is %3.2f percent (6.9 l/min)\n',diff2);

%% plot
x1 = [8,10,12,15,20,25,30];
figure(1);

plot(x1,com_eff);
hold on
plot(x1,comeff);
title('Summer condition');
xlabel('Shower duration (min)');
ylabel('Efficiency (%)');
ylim([55 65]);
legend('5.2 l/min','6.8 l/min');

