clc
clear all
close all


%% simple efficiency tests 5.4 l/min
s1test1 = xlsread('average.xlsx','D5:D11');
s1test2 = xlsread('average.xlsx','D14:D20');
s1test3 = xlsread('average.xlsx','D23:D29');
s1test4 = xlsread('average.xlsx','D32:D38');
s1test5 = xlsread('average.xlsx','D41:D47');
s1test6 = xlsread('average.xlsx','D50:D56');

du81 = [s1test1(1),s1test2(1),s1test3(1),s1test4(1),s1test5(1),s1test6(1)];
du101 = [s1test1(2),s1test2(2),s1test3(2),s1test4(2),s1test5(2),s1test6(2)];
du121 = [s1test1(3),s1test2(3),s1test3(3),s1test4(3),s1test5(3),s1test6(3)];
du151 = [s1test1(4),s1test2(4),s1test3(4),s1test4(4),s1test5(4),s1test6(4)];
du201 = [s1test1(5),s1test2(5),s1test3(5),s1test4(5),s1test5(5),s1test6(5)];
du251 = [s1test1(6),s1test2(6),s1test3(6),s1test4(6),s1test5(6),s1test6(6)];
du301 = [s1test1(7),s1test2(7),s1test3(7),s1test4(7),s1test5(7),s1test6(7)];

%% complex efficicency tests 5.4 l/min
c1test1 = xlsread('average.xlsx','I5:I11');
c1test2 = xlsread('average.xlsx','I14:I20');
c1test3 = xlsread('average.xlsx','I23:I29');
c1test4 = xlsread('average.xlsx','I32:I38');
c1test5 = xlsread('average.xlsx','I41:I47');
c1test6 = xlsread('average.xlsx','I50:I56');

dur81 = [c1test1(1),c1test2(1),c1test3(1),c1test4(1),c1test5(1),c1test6(1)];
dur101 = [c1test1(2),c1test2(2),c1test3(2),c1test4(2),c1test5(2),c1test6(2)];
dur121 = [c1test1(3),c1test2(3),c1test3(3),c1test4(3),c1test5(3),c1test6(3)];
dur151 = [c1test1(4),c1test2(4),c1test3(4),c1test4(4),c1test5(4),c1test6(4)];
dur201 = [c1test1(5),c1test2(5),c1test3(5),c1test4(5),c1test5(5),c1test6(5)];
dur251 = [c1test1(6),c1test2(6),c1test3(6),c1test4(6),c1test5(6),c1test6(6)];
dur301 = [c1test1(7),c1test2(7),c1test3(7),c1test4(7),c1test5(7),c1test6(7)];


%% simple efficiency tests 6.5 l/min
s2test1 = xlsread('average.xlsx','N5:N11');
s2test2 = xlsread('average.xlsx','N14:N20');
s2test3 = xlsread('average.xlsx','N23:N29');
s2test4 = xlsread('average.xlsx','N32:N38');
s2test5 = xlsread('average.xlsx','N41:N47');
s2test6 = xlsread('average.xlsx','N50:N56');

du82 = [s2test1(1),s2test2(1),s2test3(1),s2test4(1),s2test5(1),s2test6(1)];
du102 = [s2test1(2),s2test2(2),s2test3(2),s2test4(2),s2test5(2),s2test6(2)];
du122 = [s2test1(3),s2test2(3),s2test3(3),s2test4(3),s2test5(3),s2test6(3)];
du152 = [s2test1(4),s2test2(4),s2test3(4),s2test4(4),s2test5(4),s2test6(4)];
du202 = [s2test1(5),s2test2(5),s2test3(5),s2test4(5),s2test5(5),s2test6(5)];
du252 = [s2test1(6),s2test2(6),s2test3(6),s2test4(6),s2test5(6),s2test6(6)];
du302 = [s2test1(7),s2test2(7),s2test3(7),s2test4(7),s2test5(7),s2test6(7)];

%% complex efficicency tests 6.5 l/min
c2test1 = xlsread('average.xlsx','S5:S11');
c2test2 = xlsread('average.xlsx','S14:S20');
c2test3 = xlsread('average.xlsx','S23:S29');
c2test4 = xlsread('average.xlsx','S32:S38');
c2test5 = xlsread('average.xlsx','S41:S47');
c2test6 = xlsread('average.xlsx','S50:S56');

dur82 = [c2test1(1),c2test2(1),c2test3(1),c2test4(1),c2test5(1),c2test6(1)];
dur102 = [c2test1(2),c2test2(2),c2test3(2),c2test4(2),c2test5(2),c2test6(2)];
dur122 = [c2test1(3),c2test2(3),c2test3(3),c2test4(3),c2test5(3),c2test6(3)];
dur152 = [c2test1(4),c2test2(4),c2test3(4),c2test4(4),c2test5(4),c2test6(4)];
dur202 = [c2test1(5),c2test2(5),c2test3(5),c2test4(5),c2test5(5),c2test6(5)];
dur252 = [c2test1(6),c2test2(6),c2test3(6),c2test4(6),c2test5(6),c2test6(6)];
dur302 = [c2test1(7),c2test2(7),c2test3(7),c2test4(7),c2test5(7),c2test6(7)];

%% plot
x1 = [8,10,12,15,20,25,30]; 
sim1 = [mean(du81),mean(du101),mean(du121),mean(du151),mean(du201),mean(du251),mean(du301)];
com1 = [mean(dur81),mean(dur101),mean(dur121),mean(dur151),mean(dur201),mean(dur251),mean(dur301)];

sim2 = [mean(du82),mean(du102),mean(du122),mean(du152),mean(du202),mean(du252),mean(du302)];
com2 = [mean(dur82),mean(dur102),mean(dur122),mean(dur152),mean(dur202),mean(dur252),mean(dur302)];

plot(x1,com1);
hold on
plot(x1,com2);
ylim([55 65]);
title('Winter condition')
ylabel('Efficiency (%)');
xlabel('Shower duration (min)');
legend('5.4 l/min','6.5 l/min');

%% difference
% 5.4 l/min
difT11 = (c1test1-s1test1)./c1test1;
difT21 = (c1test2-s1test2)./c1test2;
difT31 = (c1test3-s1test3)./c1test3;
difT41 = (c1test4-s1test4)./c1test4;
difT51 = (c1test5-s1test5)./c1test5;
difT61 = (c1test6-s1test6)./c1test6;

meandif1 = mean(mean([difT11, difT21,difT31,difT41,difT51,difT61]))*100;
fprintf('\nwinter 5.4 l/min, %3.2f percent difference\n',meandif1);

%6.5 l/min
%% difference
difT12 = (c2test1-s2test1)./c2test1;
difT22 = (c2test2-s2test2)./c2test2;
difT32 = (c2test3-s2test3)./c2test3;
difT42 = (c2test4-s2test4)./c2test4;
difT52 = (c2test5-s2test5)./c2test5;
difT62 = (c2test6-s2test6)./c2test6;

meandif2 = mean(mean([difT11, difT21,difT31,difT41,difT51,difT61]))*100;
fprintf('\nwinter 6.5 l/min, %3.2f percent difference\n',meandif2);

%% plot tests
figure(2)
subplot(1,2,1)
plot(x1,c1test1)
hold on
plot(x1,c1test2)
hold on
plot(x1,c1test3)
hold on
plot(x1,c1test4)
hold on
plot(x1,c1test5)
hold on
plot(x1,c1test6)
title('Shower with 5.4 l/min');
xlabel('shower duration (min)');
ylim([55,65]);
ylabel('Efficiency (%)');
legend('test 1','test 2','test 3','test 4','test 5','test 6');

subplot(1,2,2)
plot(x1,c2test1)
hold on
plot(x1,c2test2)
hold on
plot(x1,c2test3)
hold on
plot(x1,c2test4)
hold on
plot(x1,c2test5)
hold on
plot(x1,c2test6)
title('Shower with 6.5 l/min');
xlabel('shower duration (min)');
ylim([55,65]);
ylabel('Efficiency (%)');
legend('test 1','test 2','test 3','test 4','test 5','test 6');
